<?php defined('SYSPATH') or die('No direct script access.');

class Controller_Dashboard extends Controller_Template {

   public $template = 'template';
	
	public function before()
	{
			
			parent::before();
			$session = Session::instance();
			
						//проверка соединения с базой данных
			if(count(Kohana::find_file('config', 'artonitcity_config', 'php')) == 0) $this->redirect('errorpage?err=no config file');
			
			try
			{
				$db=Database::instance('fb')->connect();
				
		
			} catch (Exception $e) {
					$err=$e->getMessage();
					$this->redirect('errorpage?err='.Text::limit_chars($err, strpos($err,'"'), '...'));
					
			}
			
		
	}
	

	public function action_index()
	{	
		//Проверка авторизации
		if (!empty($_POST)) {
             	$username = Arr::get($_POST, 'username');
                $password = Arr::get($_POST, 'password');
			
                if (Auth::instance()->login($username, $password)) {
                $user = Auth::instance()->get_user();
				}
			}
			$config_windows=Kohana::$config->load('artonitcity_config')->main_windows;
			
			
	// подготовка и вывод информации для панелей №№ 1, 2, 3.
		
		$_SESSION['menu_active']='index';
		$a=array();
		$event_stat=array();
		$system_events=array();
		if(Arr::get($config_windows, 'windows1', FALSE)) $a=Model::Factory('Stat')->stat();
		if(Arr::get($config_windows, 'windows5', FALSE)) $system_events=Model::Factory('Stat')->detect_change_device_count();
		if(Arr::get($config_windows, 'windows4', FALSE)) $event_stat=Model::Factory('Event')->stat();// подготовка статистических данных для раздела События. Готовится массив данных $list['card'], $list['device'], $list['order']
		$content = View::factory('dashboard', array(
			'list' => $a,
			'event_stat' => $event_stat,
			'event_stat_enable' => Arr::get($config_windows, 'windows4'),
			'system_events' => $system_events,
			'system_events_enable' => Arr::get($config_windows, 'windows5'),
				
			));
		
		// подготовка данных по событиям для панели №4
		$a=array();
		$a=Model::Factory('event')->event_invalid(true);
				
		$content_i = View::factory('Event/invalid_general', array(
			'event_stat' => $a,
			'event_stat_enable' => Arr::get($config_windows, 'windows6'),
			));		
		$content = $content.$content_i;
		
		$this->template->content = $content;
		//echo View::factory('profiler/stats');
		
	}

	public function action_log()// просмотр лог-файлы
	{
		$_SESSION['menu_active']='log';
		$res1=Model::Factory('Log')->getList();
		$res2=Model::Factory('Log')->getListCompare();
		
		$content=View::factory('Log', array(
			'list1'=> $res1,
			'list2'=> $res2,
			));
		$this->template->content = $content;
	}
	
	public function action_sendFile ()//передача данных пользователю
	{
		$file=Arr::get($_GET, 'name');	
		//echo Debug::vars('58', $file); exit;
		$content = Model::Factory('Log')->send_file($file);
		$this->template->content = $content;
	}
	
	public function action_load() //таблица загрузки контроллеров
	{
        $_SESSION['menu_active']='load';
		$brows=Arr::get($_POST, 'browser');
		
		if(array_key_exists('browser',$_POST)) $_SESSION['brows']=Arr::get($_POST, 'browser');
		$b=Model::Factory('Stat')->load_table();
		//echo Debug::vars('109', $b); exit;
		$content = View::factory('load_table', array(
			'list' => $b,
			'brows'=>$brows,
		));
        $this->template->content = $content;
        //echo View::factory('profiler/stats');
		
	}
	
	public function action_load_order()
	{
		
		$_SESSION['menu_active']='load_order';
		
		if(!empty($_POST['stop_load'])) Model::Factory('Stat')->stop_load($_POST['stop_load']);
		if(Arr::get($_POST, 'reload', 0)) Model::Factory('Stat')->repeat_load(Arr::get($_POST, 'reload'));
		if(Arr::get($_POST, 'del_queue', 0)) Model::Factory('Stat')->del_queue(Arr::get($_POST, 'reload'));
		
		$b=Model::Factory('Stat')->load_order();
		$c=Model::Factory('Stat')->load_order_overcount();
		
		$content = View::factory('order_table', array(
			'list' => $b,
			'overcount'=>$c,
		));
        $this->template->content = $content;
		
		
	}
    
	public function ErrMess ($err=false)
	{
		$content = View::factory('errorpage');
		$this->template->content = $content;
	}
	
	public function action_device_control()// обработка кнопок рыботы с контролерами
	{
		$_SESSION['menu_active']='device_control';
		//echo Debug::vars('144', $_POST, $_SESSION); exit;
		$res='';
		if(array_key_exists('all',$_POST)) 
			{
				$id_dev=Model::Factory('Device')->getdeviceList();
			} else {
			
				$id_dev=Arr::get($_POST, 'id_dev'); 
			}
		
		if (Arr::get($_POST, 'synctime'))
		{
				Log::instance()->add(Log::NOTICE, 'Synctime for device :user', array(
					'user' => implode(",",$id_dev),
				));
				
				
				$res=$res.Model::Factory('Device')->synctime($id_dev);
				
		}
		
		if (Arr::get($_POST, 'checkStatus'))// запись состояния контроллера в БД: версия контроллера, контоль линии связи, кол-во карт в указаанной канале (только в одном!!!), кол-во карт двери по базе данных.
		{
				
				$res=Model::Factory('Device')->insertStatusIdDev_arr($id_dev);
		}
		
		if (Arr::get($_POST, 'checkStatusOnLine'))
		{
				$res=Model::Factory('Device')->checkStatusOnLine($id_dev);
				$b=Model::Factory('Stat')->load_table($id_dev, $res);
				
		}
		
		if (Arr::get($_POST, 'load_card'))
		{
				
				$res=Model::Factory('Device')->load_card_arr($id_dev);
		}
		
		
		if (Arr::get($_POST, 'clear_device'))
		{
				$res=Model::Factory('Device')->clear_device_arr($id_dev);
		}
		
		if (Arr::get($_POST, 'settz'))
		{
				$res=Model::Factory('Device')->settz_arr($id_dev);
		}
		
		if (Arr::get($_POST, 'readkey'))//вычитать данные из контроллеров и записать их в файл.
		{
				$res=Model::Factory('Device')->readkey_arr($id_dev);
		}
		
		if (Arr::get($_POST, 'checkkey'))//вычитать данные из контроллера, сравинть с БД, записать их в файл.
		{
				//echo Debug::vars('205', $_POST ); exit;
				$res=Model::Factory('Check')->checkKey($id_dev, NULL);
		}
		
		
		
		$content = View::factory('result', array(
			'content' => $res,
		));
		
        $this->template->content = $content;
	}

	
}